/**
* \file: PfCfgConfiguration.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: AAUTO
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_PFCFGCONFIGURATION_H
#define AAUTO_PFCFGCONFIGURATION_H

#include <list>
#include <map>
#include <string>
#include <adit_logging.h>
#include "IConfiguration.h"

namespace adit { namespace aauto
{

class PfCfgConfiguration : public IDynamicConfiguration
{
public:
    /**
     * Read configuration from file *.cfg.
     * Stores key and value in a std::map.
     * Afterwards, there is no further access to *.cfg.
     *
     * \param [in] fileName - name of configuration file to read.
     *
     * \return IDynamicConfiguration - reference to configuration object
     */
    static PfCfgConfiguration* FromFile(const std::string& fileName);

    virtual ~PfCfgConfiguration();

    void SetItem(const std::string& key, const std::string& value);
    bool TryGetItem(const std::string& key, std::string& result) const;

    /**
     * Read configuration item with more than one line.
     * All items read until next number is not available.
     * example-item-0
     * example-item-1
     *
     * \param [in] key - key name of the item without the number and the "-" before
     *
     * \return list<string> list of the items or empty if nothing found
     */
    std::list<std::string> GetItems(const std::string& key) const;

    /**
     * Search for first non-space entry (which is properly the key)
     * in input string and return result.
     *
     * \param [in] inString     string which contains the key
     *
     * \return <string> value e.g. key of the item or empty string
     */
    std::string GetKey(const std::string& inString) const;

    /**
     * Search for last non-space entry (which is properly the value)
     * in input string and return result.
     *
     * \param [in] inString     string which contains the value
     *
     * \return <string> value of the item or empty string
     */
    std::string GetValue(const std::string& inString) const;
private:
    PfCfgConfiguration();

    std::map<std::string, std::string> config;

    bool checkItem(const std::string& key, std::string& value) const;
    void insert(const std::string& key, const std::string& value);
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_PFCFGCONFIGURATION_H */
